from machine import Pin
import network
from onewire import OneWire
from ds18x20 import DS18X20
from time import sleep

ssid = 'xxxxxxxxxxxxx' #Your network name
password = 'xxxxxxxxxxx' #Your WiFi password

led_onboard = Pin("LED", Pin.OUT)

#Connect to WLAN
wlan = network.WLAN(network.STA_IF)
wlan.active(True)
wlan.connect(ssid, password)
while wlan.isconnected() == False:
    led_onboard.value(0)
    print('Connecting...')
    sleep(1)
ip = wlan.ifconfig()[0]
print('Connection successful')
print(f'Connected on {ip} \n')
led_onboard.value(1)

# Initialization GPIO, OneWire and DS18B20
one_wire_bus = Pin(26) #pin 31 in PICO W
sensor_ds = DS18X20(OneWire(one_wire_bus))

# Discover one-wire devices
devices = sensor_ds.scan()

# Create the connection to our Firebase database - don't forget to change the URL!
import ufirebase as firebase
firebase.setURL("https://xxxxxxxxxxxxxxxxxxxxx-rtdb.firebaseio.com/")

while True:
    try:
    # Measure temperature
        sensor_ds.convert_temp()
    # Query sensors
        for device in devices:
                temp = sensor_ds.read_temp(device)
                temp_C = "{:.1f}".format(temp)
                #print('Temp_C :', temp_C , '°C')
                temp_f = ((sensor_ds.read_temp(device)) * (9/5) + 32)
                temp_F = "{:.1f}".format(temp_f)
                #print('Temp_F:', temp_F, '°F \n')
        firebase.put("Temp_C", temp_C, bg=0)
 
    except OSError as e:
        #continue
        print('Connection closed')